import Pkg
Pkg.add("Roots")

using Roots
using Printf

T=(4.)/27*0.75
tolerance=1e-4

function f(rho::Float64,T::Float64)
  return T*rho*(log(rho/(1 - rho)) - 1) - rho^2/2
end
function df(rho::Float64,T::Float64)
  return -rho + T*(1 - rho)*((1.)/(1 - rho)^2) + T*(log(rho/(1 - rho))-1)
end


# find bounds of negative compressibility
rhocs=find_zeros(rho->rho*(1-rho)^2-T,0.,1.)

# error if do not find two
if length(rhocs)!=2
  print("error: did not find bounds for the negative compressibility region\n")
  print("found: ")
  print(rhocs)
  print("\n")
  exit(-1)
end

@printf("In f.gnuplot, set\nrho1=%.15e\nrho2=%.15e\n\n",rhocs[1],rhocs[2])

# initialize guess
rho1=0.
rho2=rhocs[1]
rho=(rho1+rho2)/2

# loop
while true
  global rho,T,rho1,rho2
  # compute the intersections with the tangent
  inters=find_zeros(x->f(rho,T)+df(rho,T)*(x-rho)-f(x,T),rhocs[2],1.)
  if (length(inters)==0)
    rho1=rho
    rho=(rho1+rho2)/2
    #@printf("Too small: trying %f\n",rho)
  else
    if(abs(df(inters[1],T)-df(rho,T))>tolerance)
      rho2=rho
      rho=(rho1+rho2)/2
      #@printf("Too large: trying %f\n",rho)
    else
      @printf("In f_tangent.gnuplot, set\nrho1=%.15e\nrho2=%.15e\n\n",rho,inters[1])
      break
    end
  end
end
