# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone
# run
## gnuplot gnuplots && gnuplot_tikz out/latext/minimizer.tex

# plot options
#set title ""
set ylabel "$f$" norotate
set xlabel "$\\rho$"

set xrange[0:1]
set yrange [-0.35:0]

## start ticks at 0, then every x
#set xtics 0,x
#set ytics 0,x
## puts 4 minor tics between tics (5 intervals, i.e. every 0.01)
#set mxtics 5
#set mytics 5
unset xtics
unset ytics

set key off

## 3=1+2 draw bottom and left sides of the box
#set border 3
## don't show tics on opposite sides
#set xtics nomirror
#set ytics nomirror

# set linestyle 1
set style line 1 linetype rgbcolor "#4169E1" linewidth 2
set style line 2 linetype rgbcolor "#DC143C" linewidth 2
set style line 3 linetype rgbcolor "#32CD32" linewidth 2
set style line 4 linetype rgbcolor "#4B0082" linewidth 2
set style line 5 linetype rgbcolor "#DAA520" linewidth 2

set pointsize 1

f(alpha,rho)=rho*(alpha*4/27*log(rho/(1-rho))-rho/2-alpha*4/27)

rho1=5.906967312405406e-02
rho2=6.806840982405374e-01
T=0.75

plot f(T,x) with lines linestyle 1 title "$T<T_c$" ,\
  (x>rho1 && x<rho2 ? f(T,x) : 1/0) with lines linestyle 2 ,\
  (x>rho1 && x<rho2 ? f(T,rho1)+(f(T,rho2)-f(T,rho1))/(rho2-rho1)*(x-rho1) : 1/0) with lines linestyle 1 dashtype "."

