# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone
# run
## gnuplot gnuplots && gnuplot_tikz out/latext/minimizer.tex

# plot options
#set title ""
#set ylabel "" norotate
#set xlabel ""

set xrange[0:3]
set yrange [-1:2]

## start ticks at 0, then every x
unset ytics
set xtics 0,1
set xtics add ("" 0,"$R$" 1, "" 2, "" 3)
## puts 4 minor tics between tics (5 intervals, i.e. every 0.01)
#set mxtics 5
#set mytics 5

set key off

## 3=1+2 draw bottom and left sides of the box
#set border 3

# set linestyle 1
set style line 1 linetype rgbcolor "#4169E1" linewidth 2
set style line 2 linetype rgbcolor "#DC143C" linewidth 2
set style line 3 linetype rgbcolor "#32CD32" linewidth 2
set style line 4 linetype rgbcolor "#4B0082" linewidth 2
set style line 5 linetype rgbcolor "#DAA520" linewidth 2
set style line 6 linetype rgbcolor "#000000" linewidth 1 dashtype "."

set pointsize 1

set object rectangle from 0,-1 to 1,2 fillcolor rgb "#444444" fillstyle solid noborder
set arrow from 1,-1 to 1,2 nohead ls 1
set label at 2,-0.25 "$\\varphi$"

plot 0 ls 6,\
  -1/x**3 with lines linestyle 1
