# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone
# run
## gnuplot gnuplots && gnuplot_tikz out/latext/minimizer.tex

# plot options
#set title ""
set ylabel "$f_0-(J_1+2d J_2)/2\\rho^2-\\lambda\\rho$"
set xlabel "$\\rho$"

set xrange[-2:2]
set yrange [:1.3]

## start ticks at 0, then every x
#set xtics 0,x
#set ytics 0,x
## puts 4 minor tics between tics (5 intervals, i.e. every 0.01)
#set mxtics 5
#set mytics 5
unset xtics
unset ytics

set key top center box linetype rgbcolor"#999999" width 3.0 height 0.3 spacing 1.3


# set linestyle 1
set style line 1 linetype rgbcolor "#4169E1" linewidth 2
set style line 2 linetype rgbcolor "#DC143C" linewidth 2
set style line 3 linetype rgbcolor "#32CD32" linewidth 2
set style line 4 linetype rgbcolor "#4B0082" linewidth 2
set style line 5 linetype rgbcolor "#DAA520" linewidth 2

set pointsize 1

plot 2*x**4-3*x**2-1*x with lines linestyle 1 title "$\\lambda<\\lambda_c$",\
  2*x**4-3*x**2 with lines linestyle 4 title "$\\lambda=\\lambda_c$" ,\
  2*x**4-3*x**2+1*x with lines linestyle 2 title "$\\lambda>\\lambda_c$"
