# Random configuration of hard spheres

using Printf

# number of spheres
N=500
# radius
R=1
# sidelength
L=100

# list of spheres
spheres=Array{Tuple{Float64,Float64},1}()

while (length(spheres)<N)
  x=rand()*L
  y=rand()*L
  # check that it doesn't overlap
  canadd=true
  for z in spheres
    if ((x-z[1])^2+(y-z[2])^2<=R^2)
      canadd=false
      break
    end
  end
  if canadd
    push!(spheres,(x,y))
  end
end

for z in spheres
  @printf("% .15e % .15e\n",z[1],z[2])
end
