# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 6,6 standalone
# run
## gnuplot gnuplots && gnuplot_tikz out/latext/minimizer.tex

# plot options
#set title ""
#set ylabel "" norotate
#set xlabel ""

#set xrange[:]
#set yrange [:]

## start ticks at 0, then every x
#set xtics 0,x
#set ytics 0,x
## puts 4 minor tics between tics (5 intervals, i.e. every 0.01)
#set mxtics 5
#set mytics 5
unset xtics
unset ytics

set key off


# set linestyle 1
set style line 1 linetype rgbcolor "#4169E1" linewidth 2
set style line 2 linetype rgbcolor "#DC143C" linewidth 2
set style line 3 linetype rgbcolor "#32CD32" linewidth 2
set style line 4 linetype rgbcolor "#4B0082" linewidth 2
set style line 5 linetype rgbcolor "#DAA520" linewidth 2
set style line 6 linetype rgbcolor "#000000" linewidth 1

set pointsize 1

set arrow nohead from 25,0 to 25,100
set arrow nohead from 50,0 to 50,100
set arrow nohead from 75,0 to 75,100
set arrow nohead from 0,25 to 100,25
set arrow nohead from 0,50 to 100,50
set arrow nohead from 0,75 to 100,75

set arrow from 105,0 to 105,25 heads
set label at 108,12 "$\\gamma^{-1}$"
set arrow from 75,-5 to 100,-5 heads
set label at 87,-10 "$\\gamma^{-1}$" center

plot "box.dat" using 1:2:(0.5) with circles fill solid linestyle 6
