# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone

unset key

unset xtics
unset ytics
unset ztics
unset border

unset colorbox

set pointsize 1

#set xrange [0:4*pi/3]
#set yrange [-2*pi/sqrt(3):2*pi/sqrt(3)]

set pm3d depthorder

# make this odd and divisible by 7 to get the Fermi points
set isosamples 49

# rescale x and y components to render the Fermi points better
# units of 2*pi/3
set xrange [0:2]
# units of 2*pi/(3*sqrt(3))
set yrange [-3:3]

set view 80,35

splot sqrt(1+4*cos(pi*x)*cos(pi/3*y)+4*cos(pi/3*y)**2) w pm3d, -sqrt(1+4*cos(pi*x)*cos(pi/3*y)+4*cos(pi/3*y)**2) w pm3d

#pause mouse close
