class Plot {
  constructor(canvas, xmin, xmax, ymin, ymax, border=10, point_radius=5){

    // get elements
    this.canvas=canvas;
    this.context=canvas.getContext("2d");

    this.xmin=xmin;
    this.xmax=xmax;
    this.ymin=ymin;
    this.ymax=ymax;
    this.border=border;
    this.point_radius=point_radius;
  }

  // convert coordinates to position within canvas
  xcanv(x){
    return((this.canvas.width-2*this.border)*(x-this.xmin)/(this.xmax-this.xmin)+this.border);
  }
  ycanv(y){
    // abcissa is inverted in html5
    return((this.canvas.height-2*this.border)*(1-(y-this.ymin)/(this.ymax-this.ymin))+this.border);
  }
  // inverses
  xcanv_inv(x){
    return(this.xmin+(this.xmax-this.xmin)/(this.canvas.width-2*this.border)*(x-this.border));
  }
  ycanv_inv(y){
    return(this.ymin+(this.ymax-this.ymin)*(1-(y-this.border)/(this.canvas.height-2*this.border)));
  }

  // draw graph
  draw(x,y){
    this.context.clearRect(0,0,this.canvas.width,this.canvas.height);

    // draw point
    this.context.beginPath();
    this.context.arc(this.xcanv(x),this.ycanv(y),this.point_radius,0,2*Math.PI);
    this.context.fill();
  }

  // draw axes
  draw_axes(){
    this.context.clearRect(0,0,this.canvas.width,this.canvas.height);

    this.context.beginPath();
    this.context.moveTo(this.xcanv(this.xmin),this.ycanv(0));
    this.context.lineTo(this.xcanv(this.xmax),this.ycanv(0));
    this.context.moveTo(this.xcanv(0),this.ycanv(this.ymin));
    this.context.lineTo(this.xcanv(0),this.ycanv(this.ymax));
    this.context.strokeStyle='rgb(0,0,0)';
    this.context.stroke();
  }
}

class Plot_trajectory extends Plot {
  constructor(canvas_pos, canvas_traj, xmin, xmax, ymin, ymax, border=10, point_radius=5){
    super(canvas_pos, xmin, xmax, ymin, ymax, border, point_radius)

    // get elements
    this.traj=canvas_traj;
    this.traj_context=canvas_traj.getContext("2d");
  }

  // draw trajectory
  draw_trajectory(x,y,oldx,oldy,t){
    this.traj_context.beginPath();
    this.traj_context.moveTo(this.xcanv(oldx),this.ycanv(oldy));
    this.traj_context.lineTo(this.xcanv(x),this.ycanv(y));
    this.traj_context.strokeStyle=rgb(fmod(t/20,1));
    this.traj_context.lineWidth=2;
    this.traj_context.stroke();
  }

  // draw axes
  draw_axes(){
    this.context.clearRect(0,0,this.canvas.width,this.canvas.height);
    this.traj_context.clearRect(0,0,this.canvas.width,this.canvas.height);

    this.traj_context.beginPath();
    this.traj_context.moveTo(this.xcanv(this.xmin),this.ycanv(0));
    this.traj_context.lineTo(this.xcanv(this.xmax),this.ycanv(0));
    this.traj_context.moveTo(this.xcanv(0),this.ycanv(this.ymin));
    this.traj_context.lineTo(this.xcanv(0),this.ycanv(this.ymax));
    this.traj_context.strokeStyle='rgb(0,0,0)';
    this.traj_context.stroke();
  }
}

class Plot_scatter extends Plot {
  constructor(canvas_pos, xmin, xmax, ymin, ymax, border=10, point_radius=5){
    super(canvas_pos, xmin, xmax, ymin, ymax, border, point_radius)

    // init points array
    this.points=new Array();
  }

  // draw points
  draw(){
    this.context.clearRect(0,0,this.canvas.width,this.canvas.height);

    for (const point of this.points){
      // draw point
      this.context.beginPath();
      this.context.arc(this.xcanv(point[0]),this.ycanv(point[1]),this.point_radius,0,2*Math.PI);
      this.context.fill();
    }
  }

  // add a point to plot
  add_point(x,y){
    this.points.push(new Array(x,y))

    // draw point
    this.context.beginPath();
    this.context.arc(this.xcanv(x),this.ycanv(y),this.point_radius,0,2*Math.PI);
    this.context.fill();
  }
}
