%%
%% Ian's presentation class
%%

%% TeX format
\NeedsTeXFormat{LaTeX2e}[1995/12/01]

%% class name
\ProvidesClass{ian-presentation}[2017/09/29]

\def\ian@defaultoptions{
  \pagestyle{plain}
  \RequirePackage{color}
  \RequirePackage{amssymb}
}

%% paper dimensions
\setlength\paperheight{240pt}
\setlength\paperwidth{427pt}

%% fonts
\input{size11.clo}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}

%% text dimensions
\textheight=208pt
\textwidth=370pt
\hoffset=-1in
\voffset=-1in
\oddsidemargin=24pt
\evensidemargin=24pt
\topmargin=8pt
\headheight=0pt
\headsep=0pt
\marginparsep=0pt
\marginparwidth=0pt
\footskip=16pt


%% remove default skips
\parindent=0pt
\parskip=0pt
\baselineskip=0pt

%% something is wrong with \thepage, redefine it
\gdef\thepage{\the\c@page}

%% correct vertical alignment at the end of a document
\AtEndDocument{
  % save total slide count
  \immediate\write\@auxout{\noexpand\gdef\noexpand\slidecount{\thepage}}
  \vfill
  \eject
}


%% footer
\def\ps@plain{
  \def\@oddhead{}
  \def\@evenhead{\@oddhead}
  \def\@oddfoot{\tiny\hfill\thepage/\safe\slidecount\hfill}
  \def\@evenfoot{\@oddfoot}
}
\def\ps@empty{
  \def\@oddhead{}
  \def\@evenhead{\@oddhead}
  \def\@oddfoot{}
  \def\@evenfoot{\@oddfoot}
}


%% title of slide
\def\title#1{
  \hfil{\bf\large #1}\par
  \hfil\vrule width0.75\textwidth height0.3pt\par
  \vskip5pt
}


%% hyperlinks
% hyperlinkcounter
\newcounter{lncount}
% hyperref anchor
\def\hrefanchor{%
\stepcounter{lncount}%
\hypertarget{ln.\thelncount}{}%
}

%% define a command and write it to aux file
\def\outdef#1#2{%
  % define command%
  \expandafter\xdef\csname #1\endcsname{#2}%
  % hyperlink number%
  \expandafter\xdef\csname #1@hl\endcsname{\thelncount}%
  % write command to aux%
  \immediate\write\@auxout{\noexpand\expandafter\noexpand\gdef\noexpand\csname #1\endcsname{\csname #1\endcsname}}%
  \immediate\write\@auxout{\noexpand\expandafter\noexpand\gdef\noexpand\csname #1@hl\endcsname{\thelncount}}%
}

%% can call commands even when they are not defined
\def\safe#1{%
  \ifdefined#1%
    #1%
  \else%
    {\color{red}\bf?}%
  \fi%
}


%% itemize
\newlength\itemizeskip
% left margin for items
\setlength\itemizeskip{20pt}
\newlength\itemizeseparator
% space between the item symbol and the text
\setlength\itemizeseparator{5pt}
% penalty preceding an itemize
\def\itemizepenalty{0}
% counter counting the itemize level
\newcounter{itemizecount}

% item symbol
\def\itemizept#1{
  \ifnum#1=1
    \textbullet
  \else
    $\scriptstyle\blacktriangleright$
  \fi
}

\newlength\current@itemizeskip
\setlength\current@itemizeskip{0pt}
\def\itemize{
  \par\penalty\itemizepenalty\medskip\penalty\itemizepenalty
  \addtocounter{itemizecount}{1}
  \addtolength\current@itemizeskip{\itemizeskip}
  \leftskip\current@itemizeskip
}
\def\enditemize{
  \addtocounter{itemizecount}{-1}
  \addtolength\current@itemizeskip{-\itemizeskip}
  \par\leftskip\current@itemizeskip
  \medskip
}
\newlength\itempt@total
\def\item{
  \settowidth\itempt@total{\itemizept\theitemizecount}
  \addtolength\itempt@total{\itemizeseparator}
  \par
  \medskip
  \hskip-\itempt@total\itemizept\theitemizecount\hskip\itemizeseparator
}

%% enumerate
\newcounter{enumerate@count}
\def\enumerate{
  \setcounter{enumerate@count}0
  \let\olditem\item
  \let\olditemizept\itemizept
  \def\item{
    % counter
    \stepcounter{enumerate@count}
    % set header
    \def\itemizept{\theenumerate@count.}
    % hyperref anchor
    \hrefanchor
    % define tag (for \label)
    \xdef\tag{\theenumerate@count}
    \olditem
  }
  \itemize
}
\def\endenumerate{
  \enditemize
  \let\item\olditem
  \let\itemizept\olditemizept
}


%% end
\ian@defaultoptions

\endinput
