#!/usr/bin/env python3

from math import *
import random

# size of space
L=15
# number of particles
N=10

# check whether two rods overlap
def check_overlap(sphere1,sphere2):
    if(sqrt((sphere2[0]-sphere1[0])**2+(sphere2[1]-sphere1[1])**2+(sphere2[2]-sphere1[2])**2)<2):
        return(True)
    return(False)

# configuration
config=[]
# add spheres
while len(config)<N:
    # random position
    x=[random.uniform(0,L), random.uniform(0,L), random.uniform(0,L)]
    # check it does not interfere with other spheres
    fine=True
    for sphere in config:
        if(check_overlap(sphere,x)):
            fine=False
            break
    if fine:
        config.append(x)

for i in range(len(config)):
    sphere=config[i]
    print(str(sphere[0])+"+cos(u)*sin(v)", end=", ")
    print(str(sphere[1])+"+sin(u)*sin(v)", end=", ")
    print(str(sphere[2])+"+cos(v)", end="  ")
    print("with pm3d", end="")
    if i<len(config)-1:
        print(", \\")
