set title "$\\rho=10^{-7}$"
set ylabel norotate "$\\mathcal M_{\\mathrm s}$"
set xlabel "$|\\mathbf k|$"

set xtics 1e-3, 1000, 1e6
set xtics add ("$10^{-3}$" 0.001, "$10^{0}$" 1, "$10^{3}$" 1000, "$10^6$" 1000000)
unset mxtics
set xrange [1e-3:1000000]

set ytics 1e-60, 1e20, 1
set ytics add ("$10^{-60}$" 1e-60, "$10^{-40}$" 1e-40, "$10^{-20}$" 1e-20)
unset mytics
set yrange [1e-61:1e10]

# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone

set key off


# set linestyle
set style line 1 linetype rgbcolor "#4169E1" linewidth 3
set style line 2 linetype rgbcolor "#DC143C" linewidth 2
set style line 3 linetype rgbcolor "#32CD32" linewidth 2
set style line 4 linetype rgbcolor "#4B0082" linewidth 3
set style line 5 linetype rgbcolor "#DAA520" linewidth 3
set style line 6 linetype rgbcolor "#660000" linewidth 3
set style line 7 linetype rgbcolor "#003333" linewidth 3

set pointsize 1

set logscale xy

f(x)=a-4*x
g(x)=c-12*x

fit [-2:-1] f(x) "bigeq7.dat" u (log10($1)):(log10(abs($2))) via a
fit [1:] g(x) "bigeq7.dat" u (log10($1)):(log10(abs($2))) via c

set label "$|\\mathbf k|^{-4}$" at 1e-2,10**(a-4) textcolor "#660000"
set label "$|\\mathbf k|^{-12}$" at 1e3,10**(c-34) textcolor "#003333"

plot \
 "bigeq7.dat" using 1:(abs($2)) with lines ls 4 ,\
 10**(f(log10(x))) ls 6 dashtype "." ,\
 10**(g(log10(x))) ls 7 dashtype "."


