set title "$\\rho=10^{-4}$"
set ylabel norotate "$\\mathcal M_{\\mathrm s}$"
set xlabel "$|\\mathbf k|$"

set xtics 1e-3, 100, 1e3
set xtics add ("$10^{-3}$" 0.001, "$10^{-1}$" 1e-1, "$10^{1}$" 10, "$10^{3}$" 1000)
unset mxtics
set xrange [1e-3:2e3]

set ytics 1e-40, 1e10, 1
set ytics add ("$10^{-40}$" 1e-40, "$10^{-30}$" 1e-30, "$10^{-20}$" 1e-20, "$10^{-10}$" 1e-10)
unset mytics
set yrange [1e-41:1e10]

# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone

set key off


# set linestyle
set style line 1 linetype rgbcolor "#4169E1" linewidth 3
set style line 2 linetype rgbcolor "#DC143C" linewidth 2
set style line 3 linetype rgbcolor "#32CD32" linewidth 2
set style line 4 linetype rgbcolor "#4B0082" linewidth 3
set style line 5 linetype rgbcolor "#DAA520" linewidth 3
set style line 6 linetype rgbcolor "#660000" linewidth 3
set style line 7 linetype rgbcolor "#003333" linewidth 3

set pointsize 1

set logscale xy

f(x)=a-4*x
g(x)=c-12*x

fit [-2:-1] f(x) "bigeq4.dat" u (log10($1)):(log10(abs($2))) via a
fit [1:] g(x) "bigeq4.dat" u (log10($1)):(log10(abs($2))) via c

set label "$|\\mathbf k|^{-4}$" at 1e-2,10**(a) textcolor "#660000"
set label "$|\\mathbf k|^{-12}$" at 1e2,10**(c-22) textcolor "#003333"

plot \
 "bigeq4.dat" using 1:(abs($2)) every::2::118 with lines ls 4 ,\
 10**(f(log10(x))) ls 6 dashtype "." ,\
 10**(g(log10(x))) ls 7 dashtype "."


