set ylabel "$\\displaystyle\\frac{e_{\\mathrm s}}{\\rho}$" norotate offset -1,0
set xlabel "$\\rho$"

set xtics 1e-6, 100, 100
set xtics add ("$10^{-6}$" 0.000001, "$10^{-4}$" 0.0001, "$10^{-2}$" 0.01, "$1$" 1.0, "$10^2$" 100)
unset mxtics

set ytics 8,1
set mytics 2

set xrange [0.000001:100]
set yrange [7.5:13.5]

# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone

set key off


# set linestyle
set style line 1 linetype rgbcolor "#4169E1" linewidth 3
set style line 2 linetype rgbcolor "#DC143C" linewidth 3
set style line 3 linetype rgbcolor "#32CD32" linewidth 3
set style line 4 linetype rgbcolor "#4B0082" linewidth 3
set style line 5 linetype rgbcolor "#DAA520" linewidth 3

set pointsize 1

set logscale x

a=1.25435641059

plot "energy.dat" using 1:($2/$1) with lines linestyle 4 ,\
 "simpleq.dat" using 1:($2/$1) with lines linestyle 1 ,\
 2*pi*a*(1+128/15/sqrt(pi)*sqrt(x*a**3)) linestyle 5 dashtype "." ,\
 4*pi linestyle 3 dashtype "." ,\
 "holzmann_2019-09-22.dat" using 1:($2/$1) with points linestyle 2
