set ylabel "$\\eta_{\\mathrm s}$" norotate offset -1,0
set xlabel "$\\rho$"

set xtics 1e-6, 100, 100
set xtics add ("$10^{-6}$" 0.000001, "$10^{-4}$" 0.0001, "$10^{-2}$" 0.01, "$1$" 1.0, "$10^2$" 100)
unset mxtics

#set ytics 0.6, 0.1
set mytics 2

set xrange [1e-6:100]

set yrange [0.88:1]

# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone

set key off


# set linestyle
set style line 1 linetype rgbcolor "#4169E1" linewidth 3
set style line 2 linetype rgbcolor "#DC143C" linewidth 3
set style line 3 linetype rgbcolor "#32CD32" linewidth 3
set style line 4 linetype rgbcolor "#4B0082" linewidth 3
set style line 5 linetype rgbcolor "#DAA520" linewidth 3

set pointsize 1

set logscale x

a=1.25435641059

plot \
 "simpleq.dat" using 1:($3<1e-5 ? 1-$2 : 1/0) with lines ls 1,\
 "bigeq.dat" using 1:($3<1e-5 ? 1-$2 : 1/0) with lines ls 4,\
 "holzmann_2019-09-22.dat" using 1:(1-$3) with points ls 2 ,\
 1-8./(3*sqrt(pi))*sqrt(x*a**3) ls 5 dashtype "."

