set ylabel "$\\frac{C_{\\mathrm s}^{(2)}}{\\rho^2}(r)$" norotate offset -1,0
set xlabel "$r\\rho^{1/3}$"

#set xtics 1e-6, 1000, 1e6
#set xtics add ("$10^{-6}$" 0.000001, "$10^{-3}$" 0.001, "$10^{0}$" 1, "$10^{3}$" 1000, "$10^6$" 1000000)
#unset mxtics
set xrange [:3]

#set ytics 0, 1e-5, 2e-5	
#set ytics add ("$10^{-5}$" 1e-5)
#set mytics
set yrange [0.8:]

# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone

set key bottom right box linetype rgbcolor"#999999" width 3 height 0.3 spacing 1.3


rgb(r,g,b) = 65536 * int(r) + 256 * int(g) + int(b)
circle_2_rgb(x) = (x < 1./6 ? rgb(255,x*6*255,0) : \
		  (x < 2./6 ? rgb((2./6-x)*6*255,255,0) : \
		  (x < 3./6 ? rgb(0,255,(x-2./6)*6*255) : \
		  (x < 4./6 ? rgb(0,(4./6-x)*6*255,255) : \
		  (x < 5./6 ? rgb((x-4./6)*6*255,0,255) : \
		              rgb(255,0,(1-x)*6*255) \
		  )))))


set style line 1 linetype rgbcolor circle_2_rgb(0.0) linewidth 2
set style line 2 linetype rgbcolor circle_2_rgb(0.2) linewidth 2
set style line 3 linetype rgbcolor circle_2_rgb(0.4) linewidth 2
set style line 4 linetype rgbcolor circle_2_rgb(0.6) linewidth 2
set style line 5 linetype rgbcolor circle_2_rgb(0.8) linewidth 2
set style line 6 linetype rgbcolor (0,0,0) linewidth 1

set pointsize 1


plot \
 1 ls 6 notitle,\
 "2pt_5.dat" using ($1*1e-5**(1./3)):($2/1e-5**2) with lines ls 1 title "$\\rho=10^{-5}$" ,\
 "2pt_4.dat" using ($1*1e-4**(1./3)):($2/1e-4**2) with lines ls 2 title "$\\rho=10^{-4}$" ,\
 "2pt_3.dat" using ($1*1e-3**(1./3)):($2/1e-3**2) with lines ls 3 title "$\\rho=10^{-3}$" ,\
 "2pt_2.dat" using ($1*1e-2**(1./3)):($2/1e-2**2) with lines ls 4 title "$\\rho=10^{-2}$" ,\
 "2pt_1.dat" using ($1*1e-1**(1./3)):($2/1e-1**2) with lines ls 5 title "$\\rho=10^{-1}$"


