set ylabel "$\\frac{C_{\\mathrm s}^{(2)}}{\\rho^2}(r_*)$" norotate
set xlabel "$\\rho$"

set xtics 1e-4, 100, 10
set xtics add ("$10^{-4}$" 0.0001, "$10^{-3}$" 0.001, "$10^{-2}$" 0.01, "$10^{-1}$" 0.1, "$1$" 1, "$10$" 10)
unset mxtics
set xrange [0.0001:10]

#set ytics 0, 1e-5, 2e-5	
#set ytics add ("$10^{-5}$" 1e-5)
#set mytics
set yrange [0.999:]

# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone

set key off

set style line 1 linetype rgbcolor "#4169E1" linewidth 2
set style line 2 linetype rgbcolor "#DC143C" linewidth 2
set style line 3 linetype rgbcolor "#32CD32" linewidth 2
set style line 4 linetype rgbcolor "#4B0082" linewidth 2
set style line 5 linetype rgbcolor "#DAA520" linewidth 2
set style line 6 linetype rgbcolor "#000000" linewidth 1

se logscale x


plot \
 1 ls 6 notitle,\
 (x<=7.23e-4 ? 1 : sqrt(-1)) with lines ls 4 notitle,\
 "2pt_max.dat" using 1:($3/$1**2>=1 ? $3/$1**2 : 1) with lines ls 4


