set ylabel "$\\frac{C_{\\mathrm s}^{(2)}}{\\rho^2}(r)$" norotate offset -1,0
set xlabel "$r$"

# default output canvas size: 12.5cm x 8.75cm
set term lua tikz size 8,6 standalone

unset key


# set linestyle
set style line 1 linetype rgbcolor "#4169E1" linewidth 2
set style line 2 linetype rgbcolor "#DC143C" linewidth 1
set style line 3 linetype rgbcolor "#32CD32" linewidth 2
set style line 4 linetype rgbcolor "#4B0082" linewidth 2
set style line 5 linetype rgbcolor "#DAA520" linewidth 2
set style line 6 linetype rgbcolor "#555500" linewidth 2

set pointsize 0.5

rho=2e-2

plot \
 "2pt.dat" using 1:($2/rho**2) with lines ls 4,\
 "2020-08-27+correlation.dat" using 1:2 ls 2

